# Social Networks

Note: Various social network datasets are used in the literature and here we provide a collection of some of the ones found in our survey. Namely, the Zachary Karate Club, Facebook100, Infectious SocioPatterns dynamic contact networks, and the Van De Brunt Fraternity Data. Note that Facebook1684 refers to the ego network for user 1684, and this along various other users can be found in SNAP. Unfortunately, we are unable to provide this dataset at this time.
graph features handled: Clusters (generated), Dynamic, Generic, N-layers
Graph features in papers: generic,large,generic,dynamic,dynamic (continuous),clusters (generated),weighted edges,clusters (generated),clusters (pre-existing),generic,labeled nodes,layered graphs,n-layers,clusters (pre-existing),generic,large,spatial,clusters (pre-existing)
Origin Paper: An Information Flow Model for Conflict and Fission in Small Groups (https://www.notion.so/An-Information-Flow-Model-for-Conflict-and-Fission-in-Small-Groups-34bb7441d1c4482a990c99d9d4990e14?pvs=21), Learning to discover social circles in ego networks (https://www.notion.so/Learning-to-discover-social-circles-in-ego-networks-742fdd60008348ed8271f3f039005c26?pvs=21), What’s in a crowd? analysis of face-to-face behavioral networks (https://www.notion.so/What-s-in-a-crowd-analysis-of-face-to-face-behavioral-networks-6e1997f78eb84272ac3fa79ecb571cb8?pvs=21), Friendship Networks Through Time: An Actor-Oriented Dynamic Statistical Network Model (https://www.notion.so/Friendship-Networks-Through-Time-An-Actor-Oriented-Dynamic-Statistical-Network-Model-06c4d3cdd29b4568ae1aa5c9e265041a?pvs=21), Social Structure of Facebook Networks (https://www.notion.so/Social-Structure-of-Facebook-Networks-d41db3795a424c1086f4b4cf2720528e?pvs=21), Comparing Community Structure to Characteristics in Online Collegiate Social Networks (https://www.notion.so/Comparing-Community-Structure-to-Characteristics-in-Online-Collegiate-Social-Networks-156b7ef6e40c4c89b20ee42dc57a551d?pvs=21)
Originally found at: https://snap.stanford.edu/data/ego-Facebook.html
https://cs.swan.ac.uk/~dynnoslice/software.html
https://archive.org/details/oxford-2005-facebook-matrix 
https://osf.io/dcz5h
http://www.sociopatterns.org/datasets/infectious-sociopatterns-dynamic-contact-networks/
http://www-personal.umich.edu/~mejn/netdata/
Number of Graphs: 156
Appeared in years: 2015,2021,2017,2018,2020,2005,2019
Type of Collection: Aggregate collection
is it stored properly?: No
must be analyzed: No
In repo?: Yes
Related to Literature - Algorithm (1) (Dataset tag relations): Automatic Polygon Layout for Primal-Dual Visualization of Hypergraphs (https://www.notion.so/Automatic-Polygon-Layout-for-Primal-Dual-Visualization-of-Hypergraphs-09ec6b5a17ae4f5eb6aebedf0dde6467?pvs=21), Drawing Dynamic Graphs Without Timeslices (https://www.notion.so/Drawing-Dynamic-Graphs-Without-Timeslices-15310bfa5a2f4015b7a4ae0098e6c151?pvs=21), The Turing Test for Graph Drawing Algorithms (https://www.notion.so/The-Turing-Test-for-Graph-Drawing-Algorithms-2a183bdf85bf4ab0acb311d5b9615440?pvs=21), Untangling the Hairballs of Multi-Centered Small-World Online Social Media Networks (https://www.notion.so/Untangling-the-Hairballs-of-Multi-Centered-Small-World-Online-Social-Media-Networks-8d6315c26f82480cb56a0256ef7ec569?pvs=21), Network Alignment by Discrete Ollivier-Ricci Flow (https://www.notion.so/Network-Alignment-by-Discrete-Ollivier-Ricci-Flow-b9a362d8006a44cf97a1fcbfec24ea57?pvs=21), An Experimental Comparison of Fast Algorithms for Drawing General Large Graphs (https://www.notion.so/An-Experimental-Comparison-of-Fast-Algorithms-for-Drawing-General-Large-Graphs-bbb7bb7d51d84d109030dee3c06d895d?pvs=21), Anisotropic Radial Layout for Visualizing Centrality and Structure in Graphs (https://www.notion.so/Anisotropic-Radial-Layout-for-Visualizing-Centrality-and-Structure-in-Graphs-c604b563b3594a69b6c8e57b5ce9f02f?pvs=21), Preserving Minority Structures in Graph Sampling (https://www.notion.so/Preserving-Minority-Structures-in-Graph-Sampling-cf062d6fa8f5484ab1190edd125f739f?pvs=21)
cleaned format?: Yes
duplicate?: No
link works?: No
Added in paper: No
Origin paper plaintext: An Information Flow Model for Conflict and Fission in Small Groups, Learning to discover social circles in ego networks, What’s in a crowd? analysis of face-to-face behavioral networks, Friendship Networks Through Time: An Actor-Oriented Dynamic Statistical Network Model, Social Structure of Facebook Networks, Comparing Community Structure to Characteristics in Online Collegiate Social Networks
Page id: 90888b3285d042d49072985b05f95203
unavailable/skip: No
Cleaned ALL data: No
first look: No
Related to Literature - Algorithm (Dataset tag relations) 1: Untangling the Hairballs of Multi-Centered Small-World Online Social Media Networks (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Untangling%20the%20Hairballs%20of%20Multi-Centered%20Small-W%20690af12a963849cd80c0285d27221086.md), Preserving Minority Structures in Graph Sampling (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Preserving%20Minority%20Structures%20in%20Graph%20Sampling%202d52160d6ac04019aaf808496f7d4240.md), Drawing Dynamic Graphs Without Timeslices (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Drawing%20Dynamic%20Graphs%20Without%20Timeslices%204da7155eac4b4979ae165f3b0f1d2b1b.md), Anisotropic Radial Layout for Visualizing Centrality and Structure in Graphs (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Anisotropic%20Radial%20Layout%20for%20Visualizing%20Centrali%20c964c73e1c2946f992cb72bac2b19c42.md), Network Alignment by Discrete Ollivier-Ricci Flow (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Network%20Alignment%20by%20Discrete%20Ollivier-Ricci%20Flow%20f49d058c38ad42c59c2baec961170d7c.md), The Turing Test for Graph Drawing Algorithms (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/The%20Turing%20Test%20for%20Graph%20Drawing%20Algorithms%209927a9580ae74b49a468a8c2816334da.md), An Experimental Comparison of Fast Algorithms for Drawing General Large Graphs (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/An%20Experimental%20Comparison%20of%20Fast%20Algorithms%20for%20%20190e5036cf974a879b50614cfff525f1.md), Automatic Polygon Layout for Primal-Dual Visualization of Hypergraphs (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Automatic%20Polygon%20Layout%20for%20Primal-Dual%20Visualiza%2078257e61a97c4b9ca0eb0a128ce89101.md), SetCoLa: High-Level Constraints for Graph Layout (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/SetCoLa%20High-Level%20Constraints%20for%20Graph%20Layout%20e1af8f01247d49b7bc7ac0562e1919cf.md), A Random Sampling O(n) Force-calculation Algorithm for Graph Layouts (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/A%20Random%20Sampling%20O(n)%20Force-calculation%20Algorithm%2086599a831f314d1cb8871a5a92420d0f.md), Structure-aware Fisheye Views for Efficient Large Graph Exploration (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Structure-aware%20Fisheye%20Views%20for%20Efficient%20Large%20%20690c77bbfc7647c098c21827e4491457.md), Revisiting Stress Majorization as a Unified Framework for Interactive Constrained Graph Visualization (../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Revisiting%20Stress%20Majorization%20as%20a%20Unified%20Framew%200765ea891e9e403593025430656f35f3.md)

# Body

## Zachary Karate Club Dataset

### Descriptions from Literature

[*The Turing Test for Graph Drawing Algorithms](https://link.springer.com/chapter/10.1007/978-3-030-68766-3_36)*  describes the dataset simply as “social network” in their Table 1.

From [Anisotropic Radial Layout for Visualizing Centrality and Structure in Graphs](https://link.springer.com/chapter/10.1007/978-3-319-73915-1_28):

> The Zachary’s karate club graph is a well known data set that is a social network of friendships in a karate club at a US university, as recorded during a study [[32](https://link.springer.com/chapter/10.1007/978-3-319-73915-1_28#ref-CR32)]. This graph contains 34 nodes, each representing an individual, and 78 unweighted edges that represent a friendship between the associated individuals (Fig. [1](https://link.springer.com/chapter/10.1007/978-3-319-73915-1_28#Fig1)). During the period of observation, a conflict between two key members, identified as the “administrator” and “instructor”, leads to a split in the club, giving it an interesting two cluster structure. In Fig. [1](https://link.springer.com/chapter/10.1007/978-3-319-73915-1_28#Fig1), nodes representing members who are part of the instructor’s and administrator’s groups are drawn in green and blue, respectively.
> 

### Example Figures

From “[The Turing Test for Graph Drawing Algorithms](https://arxiv.org/abs/2008.04869)”:

![Untitled](Social%20Networks%2090888b3285d042d49072985b05f95203/Untitled.png)

Figure from [supplementary materials](https://www.dcs.gla.ac.uk/~hcp/GD2020/) using a force directed layout. 

From “[Anisotropic Radial Layout for Visualizing Centrality and Structure in Graphs](https://link.springer.com/chapter/10.1007/978-3-319-73915-1_28)”:

![Untitled](Social%20Networks%2090888b3285d042d49072985b05f95203/Untitled%201.png)

**Fig. 1.** Visualization of Zachary’s karate club social network using (a) MDS, (b) radial layout, and (c) anisotropic radial layout. Node sizes encode betweenness centrality.

 ****From “[Network Alignment by Discrete Ollivier-Ricci Flow](https://link.springer.com/chapter/10.1007/978-3-030-04414-5_32)”:

![Untitled](Social%20Networks%2090888b3285d042d49072985b05f95203/Untitled%202.png)

**Fig. 1.** An example of Ricci curvature on the karate club graph before and after Ricci flow. The colors represent the Ricci curvature while the thickness represents the edge weight. Ricci flow deformed the edge weights until Ricci curvatures converged (−0.0027 in this case).

## Facebook100

### Description from Literature

From [Untangling the Hairballs of Multi-Centered, Small-World Online Social Media Networks](https://jgaa.info/getPaper?id=370):

> As real world samples, we use the Facebook100 dataset [40], which contains social relations of 100 higher educational institutes in the US. The network size varies from 762 to 41K vertices and from 16K to 1.6M edges. Thedataset is directly from Facebook, not sampled, and thus very complete in terms of capturing the social relations according to a widely used service at that time. Additional attributes obtained from the Facebook profiles are gender, expected year of graduation, dormitory, etc. Due to incomplete profiles, a number of attribute values are missing.
> 

## Example Figures

From [Untangling the Hairballs of Multi-Centered, Small-World Online Social Media Networks](https://jgaa.info/getPaper?id=370)

**Fig. 1.** Facebook friendships at California Institute of Technology (Caltech36). Vertex color corresponds to dormitory (gray for missing values), but has not been utilized by the layout algorithm. The layout in (a) is based on the entire graph, whereas (b)-(f) use edge embeddedness, which spreads the graph while keeping cohesive groups together. Embeddedness mapped to edge color; backbone edges dark gray.

![Untitled](Social%20Networks%2090888b3285d042d49072985b05f95203/Untitled%203.png)

# Facebook Ego Networks (Facebook 1864)

## Description from Literature

From ****[Preserving Minority Structures in Graph Sampling](https://ieeexplore.ieee.org/document/9222065)

> The Facebook1684 graph data set is an online social network with 775 nodes and 14,006 edges. The original graph and six samples are shown in Figure 4. This data set is an unbalanced graph in which two large communities include 705 nodes and two small communities/cliques contain only 70 nodes.
> 

The [supplemental](https://github.com/saibalmars/RicciFlow-SampleGraphs/tree/61f9c2c48d0de368369e232da959c4f996122e3a) material for *****[Network Alignment by Discrete Ollivier-Ricci Flow](https://link.springer.com/chapter/10.1007/978-3-030-04414-5_32)* also provides user 1864 of the Facebook ego networks in their repository. 

From [A Random Sampling O(n) Force-calculation Algorithm for Graph Layouts](https://osf.io/dcz5h):

> The ego graphs are Facebook ego graphs [[**ML12**](https://onlinelibrary.wiley.com/doi/10.1111/cgf.13724#cgf13724-bib-0060)] with the ego vertex re-added to the graph.
> 

# Example Figures

From ****[Preserving Minority Structures in Graph Sampling](https://ieeexplore.ieee.org/document/9222065)

![Untitled](Social%20Networks%2090888b3285d042d49072985b05f95203/Untitled%204.png)

**Fig. 4.** Interface for subjective assessment experiment with the Facebook1684 data set (775 nodes and 14,006 edges). The leftmost graph is the original graph. The six randomly arranged samples are generated by SST (a), FF (b), MCGS (c), RW (d), TIES (e), and RDN (f) with a sampling rate of 30%.

# Van De Bunt Fraternity

## Description from the Literature

From Preserving

> *Van De Bunt (Discrete):* shows the relationships between 32 freshmen at seven different time points. A discrete dynamic graph is built using the method of Brandes *et al.*  [[9](https://link.springer.com/chapter/10.1007/978-3-319-73915-1_31#ref-CR9)], with an undirected edge inserted into a timeslice if the participants reciprocally report “best friendship” or “friendship” at that time.
> 

# **Infectious SocioPatterns dynamic contact networks**

## Description from the Literature

From 

> 
> 

# **Syphilis Social Network**

## Description from the Literature

From [SetCoLa: High-Level Constraints for Graph Layout](https://onlinelibrary.wiley.com/doi/10.1111/cgf.13440):

> Social networks can be a powerful way to understand inter-personal relationships and are useful for tracking the spread of diseases that result from personal contact [[**RST*98**](https://onlinelibrary.wiley.com/doi/10.1111/cgf.13440#cgf13440-bib-0045), [**FHH*01**](https://onlinelibrary.wiley.com/doi/10.1111/cgf.13440#cgf13440-bib-0022), [**MRV*03**](https://onlinelibrary.wiley.com/doi/10.1111/cgf.13440#cgf13440-bib-0043), [**FHD*11**](https://onlinelibrary.wiley.com/doi/10.1111/cgf.13440#cgf13440-bib-0021)]. The ability to track and identify at risk individuals can lead to treatment and help manage the spread of the disease. In addition to the links between individuals, structuring the layout by node properties such as the social or ethnographically-identified group may reveal additional details about how the disease is spread.
> 

## Example Figures

From [SetCoLa: High-Level Constraints for Graph Layout](https://onlinelibrary.wiley.com/doi/10.1111/cgf.13440):

![Untitled](Social%20Networks%2090888b3285d042d49072985b05f95203/Untitled%205.png)

**Fig. 4.** The layout for the syphilis social network from (a) Rothenberg et al. [[RST*98](https://onlinelibrary.wiley.com/doi/10.1111/cgf.13440#cgf13440-bib-0045)]. (b) We recreated and improved the layout in SetCoLa by introducing additional padding, alignment, and circle constraints to further highlight the relative number of interactions among the different groups. For both figures, the nodes are split into three groups, from left to right: young affluent white men, younger white women, and young African-American men. Individuals not associated with any of these “core” groups are positioned above the others. In both figures, individuals diagnosed with syphilis during the outbreak are labeled with an “S” on the node label.

=== STOP RENDERING ===

Contact Network

This dataset contains the daily dynamic contact networks collected during the [Infectious SocioPatterns](http://www.sociopatterns.org/deployments/infectious-sociopatterns/) event that took place at the [Science Gallery](http://www.sciencegallery.com/) in Dublin, Ireland, during the artscience exhibition [INFECTIOUS: STAY AWAY](http://www.sciencegallery.com/infectious). Each file in the downloadable package contains a tab-separated list representing the active contacts during 20-second intervals of one day of data collection.  Each line has the form “t i j“, where i and j are the anonymous IDs of the persons in contact, and the interval during which this contact was active is [ t – 20s, t ]. If multiple contacts are active in a given interval, you will see multiple lines starting with the same value of t. Time is measured in seconds and expressed in UNIX ctime.

“This evaluation uses 109 common graphs from network science and graph algorithm research (note: many graphs from older research are no longer available online).”

# C. Lipp?

> The rest of the test graphs are taken from real-world applications. In particular, we selected graphs from the AT&T graph library [1], from C. Walshaw’s graph collection [20], and a graph that describes a social network of 2113 people that we obtained from C. Lipp.
> 

Last author of original paper,

→ facebook100 network: [https://epubs.siam.org/doi/10.1137/080734315](https://epubs.siam.org/doi/10.1137/080734315)

[https://archive.org/details/oxford-2005-facebook-matrix](https://archive.org/details/oxford-2005-facebook-matrix) ← pretty sure the internet archive is reliable? 

→ dead link in this paper

→ [http://masonporter.blogspot.com/2011/02/facebook100-data-set.html](http://masonporter.blogspot.com/2011/02/facebook100-data-set.html)
also dead link

→ here? [https://networkrepository.com/socfb.php](https://networkrepository.com/socfb.php)

from [Drawing Dynamic Graphs Without Timeslices](../Benchmark%20sets%200cc6b5e454304aec98f3b59b1a720476/Literature%20ad87f14e7097454fb2f784e2c8a2797a/Literature%20-%20Algorithm%2012e01bfc60a84007aa7d2d34293e123d/Drawing%20Dynamic%20Graphs%20Without%20Timeslices%204da7155eac4b4979ae165f3b0f1d2b1b.md)